package mocks

import mock "github.com/stretchr/testify/mock"
import statsd "github.com/cactus/go-statsd-client/statsd"
import time "time"

// Statter is an autogenerated mock type for the Statter type
type Statter struct {
	mock.Mock
}

// Close provides a mock function with given fields:
func (_m *Statter) Close() error {
	ret := _m.Called()

	var r0 error
	if rf, ok := ret.Get(0).(func() error); ok {
		r0 = rf()
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Dec provides a mock function with given fields: _a0, _a1, _a2
func (_m *Statter) Dec(_a0 string, _a1 int64, _a2 float32) error {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, int64, float32) error); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Gauge provides a mock function with given fields: _a0, _a1, _a2
func (_m *Statter) Gauge(_a0 string, _a1 int64, _a2 float32) error {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, int64, float32) error); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// GaugeDelta provides a mock function with given fields: _a0, _a1, _a2
func (_m *Statter) GaugeDelta(_a0 string, _a1 int64, _a2 float32) error {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, int64, float32) error); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Inc provides a mock function with given fields: _a0, _a1, _a2
func (_m *Statter) Inc(_a0 string, _a1 int64, _a2 float32) error {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, int64, float32) error); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// NewSubStatter provides a mock function with given fields: _a0
func (_m *Statter) NewSubStatter(_a0 string) statsd.SubStatter {
	ret := _m.Called(_a0)

	var r0 statsd.SubStatter
	if rf, ok := ret.Get(0).(func(string) statsd.SubStatter); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(statsd.SubStatter)
		}
	}

	return r0
}

// Raw provides a mock function with given fields: _a0, _a1, _a2
func (_m *Statter) Raw(_a0 string, _a1 string, _a2 float32) error {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string, float32) error); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Set provides a mock function with given fields: _a0, _a1, _a2
func (_m *Statter) Set(_a0 string, _a1 string, _a2 float32) error {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string, float32) error); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SetInt provides a mock function with given fields: _a0, _a1, _a2
func (_m *Statter) SetInt(_a0 string, _a1 int64, _a2 float32) error {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, int64, float32) error); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SetPrefix provides a mock function with given fields: _a0
func (_m *Statter) SetPrefix(_a0 string) {
	_m.Called(_a0)
}

// Timing provides a mock function with given fields: _a0, _a1, _a2
func (_m *Statter) Timing(_a0 string, _a1 int64, _a2 float32) error {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, int64, float32) error); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// TimingDuration provides a mock function with given fields: _a0, _a1, _a2
func (_m *Statter) TimingDuration(_a0 string, _a1 time.Duration, _a2 float32) error {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, time.Duration, float32) error); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}
