// Code generated by mockery v1.0.0
package mocks

import context "context"
import iam "github.com/aws/aws-sdk-go/service/iam"
import mock "github.com/stretchr/testify/mock"
import policy "code.justin.tv/systems/sandstorm/policy"

// IAMPolicyGeneratorAPI is an autogenerated mock type for the IAMPolicyGeneratorAPI type
type IAMPolicyGeneratorAPI struct {
	mock.Mock
}

// AddUsersToGroup provides a mock function with given fields: input
func (_m *IAMPolicyGeneratorAPI) AddUsersToGroup(input policy.AddUsersToGroupInput) error {
	ret := _m.Called(input)

	var r0 error
	if rf, ok := ret.Get(0).(func(policy.AddUsersToGroupInput) error); ok {
		r0 = rf(input)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// CheckGroupExistence provides a mock function with given fields: groupName
func (_m *IAMPolicyGeneratorAPI) CheckGroupExistence(groupName string) bool {
	ret := _m.Called(groupName)

	var r0 bool
	if rf, ok := ret.Get(0).(func(string) bool); ok {
		r0 = rf(groupName)
	} else {
		r0 = ret.Get(0).(bool)
	}

	return r0
}

// Create provides a mock function with given fields: request, auth, secrets
func (_m *IAMPolicyGeneratorAPI) Create(request *policy.CreateRoleRequest, auth policy.Authorizer, secrets policy.SecretsManager) (*policy.CreateRoleResponse, error) {
	ret := _m.Called(request, auth, secrets)

	var r0 *policy.CreateRoleResponse
	if rf, ok := ret.Get(0).(func(*policy.CreateRoleRequest, policy.Authorizer, policy.SecretsManager) *policy.CreateRoleResponse); ok {
		r0 = rf(request, auth, secrets)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*policy.CreateRoleResponse)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*policy.CreateRoleRequest, policy.Authorizer, policy.SecretsManager) error); ok {
		r1 = rf(request, auth, secrets)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateGroup provides a mock function with given fields: req
func (_m *IAMPolicyGeneratorAPI) CreateGroup(req policy.CreateGroupRequest) (*policy.Group, error) {
	ret := _m.Called(req)

	var r0 *policy.Group
	if rf, ok := ret.Get(0).(func(policy.CreateGroupRequest) *policy.Group); ok {
		r0 = rf(req)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*policy.Group)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(policy.CreateGroupRequest) error); ok {
		r1 = rf(req)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Delete provides a mock function with given fields: roleName, auth
func (_m *IAMPolicyGeneratorAPI) Delete(roleName string, auth policy.Authorizer) error {
	ret := _m.Called(roleName, auth)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, policy.Authorizer) error); ok {
		r0 = rf(roleName, auth)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteGroup provides a mock function with given fields: groupName, auth
func (_m *IAMPolicyGeneratorAPI) DeleteGroup(groupName string, auth policy.Authorizer) error {
	ret := _m.Called(groupName, auth)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, policy.Authorizer) error); ok {
		r0 = rf(groupName, auth)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Get provides a mock function with given fields: roleName
func (_m *IAMPolicyGeneratorAPI) Get(roleName string) (*policy.IAMRole, error) {
	ret := _m.Called(roleName)

	var r0 *policy.IAMRole
	if rf, ok := ret.Get(0).(func(string) *policy.IAMRole); ok {
		r0 = rf(roleName)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*policy.IAMRole)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(roleName)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetGroup provides a mock function with given fields: groupName
func (_m *IAMPolicyGeneratorAPI) GetGroup(groupName string) (*policy.Group, error) {
	ret := _m.Called(groupName)

	var r0 *policy.Group
	if rf, ok := ret.Get(0).(func(string) *policy.Group); ok {
		r0 = rf(groupName)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*policy.Group)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(groupName)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUser provides a mock function with given fields: username
func (_m *IAMPolicyGeneratorAPI) GetUser(username string) (policy.User, error) {
	ret := _m.Called(username)

	var r0 policy.User
	if rf, ok := ret.Get(0).(func(string) policy.User); ok {
		r0 = rf(username)
	} else {
		r0 = ret.Get(0).(policy.User)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(username)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// List provides a mock function with given fields:
func (_m *IAMPolicyGeneratorAPI) List() ([]string, error) {
	ret := _m.Called()

	var r0 []string
	if rf, ok := ret.Get(0).(func() []string); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListGroups provides a mock function with given fields:
func (_m *IAMPolicyGeneratorAPI) ListGroups() ([]*iam.Group, error) {
	ret := _m.Called()

	var r0 []*iam.Group
	if rf, ok := ret.Get(0).(func() []*iam.Group); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*iam.Group)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListPage provides a mock function with given fields: _a0, _a1
func (_m *IAMPolicyGeneratorAPI) ListPage(_a0 context.Context, _a1 *policy.ListPageInput) (*policy.ListPageOutput, error) {
	ret := _m.Called(_a0, _a1)

	var r0 *policy.ListPageOutput
	if rf, ok := ret.Get(0).(func(context.Context, *policy.ListPageInput) *policy.ListPageOutput); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*policy.ListPageOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *policy.ListPageInput) error); ok {
		r1 = rf(_a0, _a1)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListUsers provides a mock function with given fields:
func (_m *IAMPolicyGeneratorAPI) ListUsers() ([]*iam.User, error) {
	ret := _m.Called()

	var r0 []*iam.User
	if rf, ok := ret.Get(0).(func() []*iam.User); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*iam.User)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// PatchGroup provides a mock function with given fields: groupName, writeAccess
func (_m *IAMPolicyGeneratorAPI) PatchGroup(groupName string, writeAccess bool) error {
	ret := _m.Called(groupName, writeAccess)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, bool) error); ok {
		r0 = rf(groupName, writeAccess)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Put provides a mock function with given fields: request, auth, secrets
func (_m *IAMPolicyGeneratorAPI) Put(request *policy.PutRoleRequest, auth policy.Authorizer, secrets policy.SecretsManager) (*policy.PutRoleResponse, error) {
	ret := _m.Called(request, auth, secrets)

	var r0 *policy.PutRoleResponse
	if rf, ok := ret.Get(0).(func(*policy.PutRoleRequest, policy.Authorizer, policy.SecretsManager) *policy.PutRoleResponse); ok {
		r0 = rf(request, auth, secrets)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*policy.PutRoleResponse)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(*policy.PutRoleRequest, policy.Authorizer, policy.SecretsManager) error); ok {
		r1 = rf(request, auth, secrets)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// RemoveUsersFromGroup provides a mock function with given fields: input
func (_m *IAMPolicyGeneratorAPI) RemoveUsersFromGroup(input policy.RemoveUsersFromGroupInput) error {
	ret := _m.Called(input)

	var r0 error
	if rf, ok := ret.Get(0).(func(policy.RemoveUsersFromGroupInput) error); ok {
		r0 = rf(input)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}
