locals {
  localstack_admin_role = "arn:aws:iam::505345203727:role/sandstorm-testing-us-west-2-admin"
}

variable "sandstorm_apiserver_role_arn" {}
variable "sandstorm_agent_role_arn" {}

variable "sandstorm_python_testing_role_arn" {
  description = "role arn used in sandstorm-python integration tests"
}

variable "inventory_admin_testing_role_arn" {}
variable "inventory_stormwatch_testing_role_arn" {}
variable "s2s_role_arn" {}

variable "inventory_deployment_role_arn" {
  description = "this role gives access to deploying the inventory lambda"
}

variable "changelog_lambda_deployment_role_arn" {
  description = "this role gives access to deploying the changelog lambda"
}

variable "aws_profile" {}
variable "aws_account_id" {}

variable "aws_region" {
  default = "us-west-2"
}

variable sandstorm_apiserver_migrated_role_arn {}
variable sandstorm_agent_migrated_role_arn {}
variable changelog_lambda_deployment_migrated_role_arn {}
variable sandstorm_e2e_staging_env_role_arn {}

provider "aws" {
  version = "~> 1.0"
  region  = "${var.aws_region}"
  profile = "${var.aws_profile}"

  allowed_account_ids = [
    "${var.aws_account_id}",
  ]
}

provider "sandstorm" {}

resource "aws_iam_user" "dev" {
  name = "sandstorm-dev"
  path = "/"
}

resource "aws_iam_user_policy" "dev_assume_sandstorm_role" {
  name = "sandstorm_assume_role"
  user = "${aws_iam_user.dev.name}"

  policy = <<POLICY
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": [
        "sts:AssumeRole"
      ],
      "Effect": "Allow",
      "Resource": [
        "${var.sandstorm_apiserver_role_arn}",
        "${var.sandstorm_agent_role_arn}",
        "${var.inventory_admin_testing_role_arn}",
        "${var.inventory_stormwatch_testing_role_arn}",
        "${var.s2s_role_arn}",
        "${var.inventory_deployment_role_arn}",
        "${var.changelog_lambda_deployment_role_arn}",
        "${var.sandstorm_python_testing_role_arn}",
        "${var.sandstorm_apiserver_migrated_role_arn}",
        "${var.sandstorm_agent_migrated_role_arn}",
        "${var.changelog_lambda_deployment_migrated_role_arn}",
        "${var.sandstorm_e2e_staging_env_role_arn}",
        "${local.localstack_admin_role}"
      ]
    }
  ]
}
POLICY
}

resource "aws_iam_user_policy" "sandstorm_staging_roles" {
  name = "sandstorm_staging_roles"
  user = "${aws_iam_user.dev.name}"

  policy = "${data.aws_iam_policy_document.sandstorm_staging_roles_up.json}"
}

data "aws_iam_policy_document" "sandstorm_staging_roles_up" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    resources = [
      "${module.sandstorm-deployment-role.role_arn}",
      "${module.sandstorm-dev-role.role_arn}",
      "${module.sandstorm-staging-rw.role_arn}",
    ]
  }
}
