module "dev" {
  source                                = "./dev"
  aws_profile                           = "twitch-sse-dev"
  aws_account_id                        = "516651178292"
  sandstorm_apiserver_role_arn          = "arn:aws:iam::734326455073:role/sandstorm-apiserver-testing"
  sandstorm_agent_role_arn              = "arn:aws:iam::734326455073:role/sandstorm-agent-testing-rw"
  sandstorm_python_testing_role_arn     = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/sandstorm-python-dev"
  inventory_admin_testing_role_arn      = "arn:aws:iam::516651178292:role/inventory-admin-testing"
  inventory_stormwatch_testing_role_arn = "arn:aws:iam::516651178292:role/inventory-stormwatch-service-testing"
  s2s_role_arn                          = "arn:aws:iam::180116294062:role/malachai/*"
  inventory_deployment_role_arn         = "arn:aws:iam::516651178292:role/inventory-lambda-artifact-deploy"
  changelog_lambda_deployment_role_arn  = "arn:aws:iam::734326455073:role/changelog-lambda-update-function"

  sandstorm_apiserver_migrated_role_arn         = "arn:aws:iam::505345203727:role/sandstorm-apiserver-testing"
  sandstorm_agent_migrated_role_arn             = "arn:aws:iam::505345203727:role/sandstorm-agent-testing-rw"
  changelog_lambda_deployment_migrated_role_arn = "arn:aws:iam::505345203727:role/changelog-lambda-update-function"
  sandstorm_e2e_staging_env_role_arn            = "arn:aws:iam::505345203727:role/sandstorm/staging/templated/role/sandstorm-e2e-staging-env-role"
}
