resource "aws_instance" "sandstorm-agent-canary-v2" {
  ami                    = "ami-c006bfb8"
  count                  = "${var.instance_count}"
  iam_instance_profile   = "${aws_iam_instance_profile.sandstorm-agent-canary.name}"
  subnet_id              = "${var.subnet_ids[element(keys(var.subnet_ids), count.index)]}"
  instance_type          = "${var.instance_type}"
  vpc_security_group_ids = ["${var.vpc_security_group}"]
  availability_zone      = "${element(keys(var.subnet_ids), count.index)}"

  user_data = <<END_OF_STRING
#cloud-config
preserve_hostname: true
manage_etc_hosts: false
bootcmd:
  - cloud-init-per instance my_set_hostname sh -xc "echo "sandstorm-agent-canary-$INSTANCE_ID" | sed -e 's/-i-/-/g' > /etc/hostname; hostname -F /etc/hostname"
  - cloud-init-per instance my_etc_hosts sh -xc "sed -i -e '/^127.0.1.1/d' /etc/hosts; echo 127.0.1.1 $(cat /etc/hostname).${var.hostname_env}.us-west2.justin.tv $(cat /etc/hostname) >> /etc/hosts"
runcmd:
  - echo "cluster=sandstorm-agent-canary" > /etc/facter/facts.d/cluster.txt
  - echo "clean=true" > /etc/facter/facts.d/clean.txt
  - echo "twitch_environment=${var.env}" > /etc/facter/facts.d/terraform.txt
  - puppet agent --test --server=puppet.internal.justin.tv
END_OF_STRING

  tags {
    Name        = "sandstorm-agent-canary"
    Owner       = "Systems Security Engineering <sse@twitch.tv>"
    Environment = "${var.env}"
  }
}

resource "aws_iam_instance_profile" "sandstorm-agent-canary" {
  name = "${aws_iam_role.service.name}"
  role = "${aws_iam_role.service.name}"
}
