data "aws_iam_policy_document" "service-assume-role" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    principals {
      type        = "Service"
      identifiers = ["ec2.amazonaws.com"]
    }
  }
}

resource "aws_iam_role" "service" {
  name               = "TF-sandstorm-agent-canary"
  assume_role_policy = "${data.aws_iam_policy_document.service-assume-role.json}"
}

data "aws_iam_policy_document" "sandstorm-assume-role" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    resources = [
      "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/sandstorm-agent-canary",
    ]
  }
}

resource "aws_iam_policy" "sandstorm-assume-role" {
  name        = "sandstorm-assume-role-canary"
  path        = "/"
  description = "grant access to assume sandstorm role"
  policy      = "${data.aws_iam_policy_document.sandstorm-assume-role.json}"
}

resource "aws_iam_policy_attachment" "sandstorm-assume-role" {
  name = "sandstorm-assume-role-attachment-canary"

  roles = [
    "${aws_iam_role.service.name}",
  ]

  policy_arn = "${aws_iam_policy.sandstorm-assume-role.arn}"
}
