// e2e test alarms
// tests have to over a period of 2.5 hours
// - succeed less than once
resource "aws_cloudwatch_metric_alarm" "e2e-test-failures-no-successes" {
  alarm_name          = "${var.project_name}-e2e-test-no-successes-${var.env}"
  comparison_operator = "LessThanThreshold"
  evaluation_periods  = "1"
  metric_name         = "e2e-success"
  namespace           = "Sandstorm"
  period              = "9000"
  statistic           = "Sum"
  threshold           = "1"
  alarm_description   = "sandstorm e2e tests are not running"
  treat_missing_data  = "breaching"

  alarm_actions = [
    "${aws_sns_topic.pagerduty.arn}",
  ]

  ok_actions = [
    "${aws_sns_topic.pagerduty.arn}",
  ]

  dimensions {
    Environment = "${var.env}"
  }
}
