resource "aws_iam_role" "e2e" {
  name               = "${var.project_name}-${var.env}-test-runner"
  assume_role_policy = "${data.aws_iam_policy_document.e2e-arp.json}"
}

data "aws_iam_policy_document" "e2e-arp" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    effect = "Allow"

    principals = {
      type = "Service"

      identifiers = [
        "ecs.amazonaws.com",
        "ecs-tasks.amazonaws.com",
      ]
    }
  }
}

resource "aws_iam_role_policy" "sts" {
  name   = "${aws_iam_role.e2e.name}"
  role   = "${aws_iam_role.e2e.name}"
  policy = "${data.aws_iam_policy_document.e2e-rp.json}"
}

data "aws_iam_policy_document" "e2e-rp" {
  statement {
    actions = [
      "cloudwatch:putMetricData",
    ]

    effect = "Allow"

    resources = [
      "*",
    ]
  }

  statement {
    actions = [
      "sts:AssumeRole",
    ]

    effect = "Allow"

    resources = [
      "${module.sandstorm-e2e-task-role.role_arn}",
    ]
  }
}
