resource "aws_cloudwatch_event_rule" "e2e" {
  name                = "${var.project_name}-e2e-${var.env}"
  description         = "E2E task schedule"
  schedule_expression = "cron(30 * * * ? *)"
}

resource "aws_cloudwatch_event_target" "e2e" {
  rule     = "${aws_cloudwatch_event_rule.e2e.name}"
  role_arn = "${aws_iam_role.scheduler.arn}"
  arn      = "${data.aws_ecs_cluster.e2e.arn}"

  ecs_target {
    task_count          = 1
    task_definition_arn = "${aws_ecs_task_definition.e2e.arn}"
  }
}

resource "aws_iam_role" "scheduler" {
  name               = "${var.project_name}-scheduler-${var.env}"
  assume_role_policy = "${data.aws_iam_policy_document.scheduler-arp.json}"
}

data "aws_iam_policy_document" "scheduler-arp" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    effect = "Allow"

    principals = {
      type = "Service"

      identifiers = [
        "events.amazonaws.com",
      ]
    }
  }
}

resource "aws_iam_role_policy" "scheduler" {
  name   = "${var.project_name}-${var.env}"
  role   = "${aws_iam_role.scheduler.name}"
  policy = "${data.aws_iam_policy_document.scheduler-rp.json}"
}

data "aws_iam_policy_document" "scheduler-rp" {
  statement {
    actions = [
      "ecs:RunTask",
    ]

    effect = "Allow"

    resources = [
      "*",
    ]
  }
}
