resource "aws_ecs_task_definition" "e2e" {
  family = "${var.project_name}-${var.env}-e2e-test"

  task_role_arn = "${aws_iam_role.e2e.arn}"

  container_definitions = <<EOF
[
  {
    "name": "target",
    "image": "${var.e2e_test_image}:${var.env}",
    "cpu": 0,
    "memoryReservation": 256,
    "essential": true,
    "environment": [
      {
        "name": "ENVIRONMENT",
        "value": "${var.env}"
      },
      {
        "name": "SANDSTORM_CONFIGURATION_KEY",
        "value": "${module.sandstorm-e2e-task-role.test_config_secret_name}"
      },
      {
        "name": "SANDSTORM_ROLE",
        "value": "${module.sandstorm-e2e-task-role.role_arn}"
      },
      {
        "name": "E2E_REPORT_RESULTS",
        "value": "true"
      }
    ],
    "logConfiguration": {
      "logDriver": "awslogs",
      "options": {
        "awslogs-group": "${aws_cloudwatch_log_group.e2e.name}",
        "awslogs-region": "${var.region}",
        "awslogs-stream-prefix": "e2e"
      }
    }
  }
]
EOF
}
