variable "project_name" {
  default = "sandstorm-e2e"
}

variable "additional_test_arns" {
  description = "additinoal test arns to give access to running the e2e test"
  type        = "list"
  default     = []
}

variable "e2e_test_image" {
  default = "docker-registry.internal.justin.tv/sse/sandstorm-e2e-tests"
}

variable "aws_account_number" {}
variable "aws_profile" {}
variable "env" {}
variable "region" {}
variable "pagerduty_webhook_url" {}

variable "ecs_cluster_name" {
  description = "name of ecs cluster to run in"
}

variable "sandstorm_url" {
  description = "full path to app to run E2E tests against"
}

variable "sandstorm_tablename" {}

provider "aws" {
  region  = "${var.region}"
  profile = "${var.aws_profile}"

  allowed_account_ids = [
    "${var.aws_account_number}",
  ]
}
