data "sandstorm_secret" "guardian_username" {
  name = "sse/sandstorm/${var.env}/e2e/guardian_username"
}

data "sandstorm_secret" "guardian_password" {
  name = "sse/sandstorm/${var.env}/e2e/guardian_password"
}

resource "sandstorm_secret" "test_config" {
  name = "sse/sandstorm/${var.env}/e2e/test_config"

  plaintext = "${jsonencode(map(
    "environment", "${var.env}",
    "guardian_username", "${data.sandstorm_secret.guardian_username.plaintext}",
    "guardian_password", "${data.sandstorm_secret.guardian_password.plaintext}",
    "sandstorm_url", "${var.sandstorm_url}",
    "sandstorm_role_arn", "${var.sandstorm_role_arn}",
    "sandstorm_tablename", "${var.sandstorm_tablename}",
  ))}"
}
