variable "aws_profile" {
  default = "twitch-sandstorm-infra-aws"
}

variable "name" {}
variable "env" {}

variable "assume_role_identifiers" {
  type    = "list"
  default = []
}

variable "aws_account_id" {
  default = "734326455073"
}

variable "region" {
  default = "us-west-2"
}

provider "aws" {
  region  = "${var.region}"
  profile = "${var.aws_profile}"

  allowed_account_ids = [
    "${var.aws_account_id}",
  ]
}

output "role_arn" {
  value = "${aws_iam_role.sandstorm-rw.arn}"
}

output "role_name" {
  value = "${aws_iam_role.sandstorm-rw.name}"
}
