module "deployment" {
  source = "./deployment/common"

  aws_region     = "us-west-2"
  aws_account_id = "516651178292"
  aws_profile    = "twitch-sse-dev"

  s3_bucket_allowed_arns = [
    "arn:aws:iam::734326455073:root",
    "arn:aws:iam::505345203727:root",
    "arn:aws:iam::516651178292:root",
    "arn:aws:iam::289423984879:root", # twitch-s2s-dev
    "arn:aws:iam::180116294062:root", # twitch-s2s-prod
    "arn:aws:iam::111777140190:root", # twitch-teleport-aws
    "arn:aws:iam::190970224266:root", # twitch-teleport-dev
    "arn:aws:iam::508423404353:root", # securityteam+isengard
  ]

  lambda_deploy_user_name = "sandstorm-dev"
}

module "deployment_role_attachments" {
  source = "./deployment/role-attachments"

  aws_region     = "us-west-2"
  aws_account_id = "516651178292"
  aws_profile    = "twitch-sse-dev"

  lambda_deploy_user_name = "sandstorm-dev"

  lambda_deploy_user_assumable_arns = [
    "${module.deployment_testing.role_arn}",
    "${module.deployment_staging.role_arn}",
    "${module.deployment_production.role_arn}",
  ]
}

module "deployment_testing" {
  source         = "./deployment/lambda-deployment-role"
  env            = "testing"
  aws_region     = "us-west-2"
  aws_account_id = "505345203727"
  aws_profile    = "twitch-sandstorm-dev"

  lambda_deploy_user_name           = "sandstorm-dev"
  lambda_deploy_user_aws_account_id = "516651178292"

  lambda_function_arns = [
    "${module.testing.lambda_function_arns}",
  ]

  lambda_s3_keys = [
    "${module.testing.lambda_s3_keys}",
  ]

  s3_bucket_lambda_artifact_arn = "${module.deployment.lambda_s3_bucket_arn}"
}

module "deployment_staging" {
  source         = "./deployment/lambda-deployment-role"
  env            = "staging"
  aws_region     = "us-west-2"
  aws_account_id = "505345203727"
  aws_profile    = "twitch-sandstorm-dev"

  lambda_deploy_user_name           = "sandstorm-dev"
  lambda_deploy_user_aws_account_id = "516651178292"

  lambda_function_arns = [
    "${module.staging.lambda_function_arns}",
  ]

  lambda_s3_keys = [
    "${module.staging.lambda_s3_keys}",
  ]

  s3_bucket_lambda_artifact_arn = "${module.deployment.lambda_s3_bucket_arn}"
}

module "deployment_production" {
  source         = "./deployment/lambda-deployment-role"
  env            = "production"
  aws_region     = "us-west-2"
  aws_account_id = "734326455073"
  aws_profile    = "twitch-sandstorm-infra-aws"

  lambda_deploy_user_name           = "sandstorm-dev"
  lambda_deploy_user_aws_account_id = "516651178292"

  lambda_function_arns = [
    "${module.production.lambda_function_arns}",
  ]

  lambda_s3_keys = [
    "${module.production.lambda_s3_keys}",
  ]

  s3_bucket_lambda_artifact_arn = "${module.deployment.lambda_s3_bucket_arn}"
}
