resource "aws_s3_bucket" "sandstorm" {
  bucket = "sse-sandstorm"
  acl    = "private"
}

data "aws_iam_policy_document" "sandstorm-bucket-acl" {
  statement {
    sid = "uploadDownload"

    actions = [
      "s3:Put*",
      "s3:Get*",
    ]

    principals {
      type = "AWS"

      identifiers = [
        "${var.s3_bucket_allowed_arns}",
      ]
    }

    resources = [
      "${aws_s3_bucket.sandstorm.arn}/*/*.zip",
      "${aws_s3_bucket.sandstorm.arn}/*/*.hcl",
      "${aws_s3_bucket.sandstorm.arn}/*/*.json",
    ]
  }

  statement {
    sid = "ListBucket"

    actions = [
      "s3:GetBucketLocation",
      "s3:ListBucket",
    ]

    principals {
      type = "AWS"

      identifiers = [
        "${var.s3_bucket_allowed_arns}",
      ]
    }

    resources = [
      "${aws_s3_bucket.sandstorm.arn}",
    ]
  }
}

resource "aws_s3_bucket_policy" "sandstorm" {
  bucket = "${aws_s3_bucket.sandstorm.id}"
  policy = "${data.aws_iam_policy_document.sandstorm-bucket-acl.json}"
}
