resource "aws_iam_role" "config-read" {
  name               = "sandstorm-config-read"
  path               = "/sandstorm/common/"
  assume_role_policy = "${data.aws_iam_policy_document.config-read-arp.json}"
}

data "aws_iam_policy_document" "config-read-arp" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    principals = {
      type = "AWS"

      identifiers = [
        "${var.s3_bucket_allowed_arns}",
      ]
    }

    effect = "Allow"
  }
}

resource "aws_iam_role_policy" "config-read" {
  name   = "config-read"
  role   = "${aws_iam_role.config-read.id}"
  policy = "${data.aws_iam_policy_document.config-read-rp.json}"
}

data "aws_iam_policy_document" "config-read-rp" {
  statement {
    actions = [
      "s3:GetObject",
    ]

    resources = [
      "${aws_s3_bucket.sandstorm.arn}/sandstorm-configs/*",
    ]

    effect = "Allow"
  }
}
