provider "aws" {
  region  = "${var.aws_region}"
  profile = "${var.aws_profile}"

  allowed_account_ids = [
    "${var.aws_account_id}",
  ]
}

variable "s3_bucket_allowed_arns" {
  type = "list"
}

variable "aws_account_id" {}

variable "aws_profile" {}

variable "aws_region" {
  default = "us-west-2"
}

variable "lambda_deploy_user_name" {}

output "lambda_s3_bucket" {
  value = "${aws_s3_bucket.sandstorm.id}"
}

output "lambda_s3_bucket_arn" {
  value = "${aws_s3_bucket.sandstorm.arn}"
}

output "s3_config_read_role_arn" {
  value = "${aws_iam_role.config-read.arn}"
}
