resource "aws_iam_user_policy" "sandstorm-dev-sts" {
  name   = "sts"
  user   = "${var.lambda_deploy_user_name}"
  policy = "${data.aws_iam_policy_document.sandstorm-dev-sts-p.json}"
}

data "aws_iam_policy_document" "sandstorm-dev-sts-p" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    resources = [
      "${aws_iam_role.config-read.arn}",
    ]

    effect = "Allow"
  }
}
