data "aws_iam_policy_document" "lambda-update-function" {
  statement {
    sid = "lambdaUpdateFunction"

    actions = [
      "lambda:UpdateFunctionCode",
    ]

    resources = [
      "${var.lambda_function_arns}",
    ]
  }

  statement {
    sid = "uploadDownloadSourceCode"

    actions = [
      "s3:PutObject",
      "s3:GetObject",
    ]

    resources = [
      "${formatlist("${var.s3_bucket_lambda_artifact_arn}/%s", var.lambda_s3_keys)}",
    ]
  }

  statement {
    sid = "listBuckets"

    actions = [
      "s3:ListBucket",
    ]

    resources = [
      "${var.s3_bucket_lambda_artifact_arn}",
    ]
  }
}

data "aws_iam_policy_document" "lambda-update-function-arp" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    principals {
      type = "AWS"

      identifiers = [
        "arn:aws:iam::${var.lambda_deploy_user_aws_account_id}:user/${var.lambda_deploy_user_name}",
        "arn:aws:iam::${var.aws_account_id}:root",
        "arn:aws:iam::516651178292:user/jenkins",
      ]
    }

    effect = "Allow"
  }
}

resource "aws_iam_role" "lambda-update-function" {
  name               = "lambda_update_function_${var.env}"
  assume_role_policy = "${data.aws_iam_policy_document.lambda-update-function-arp.json}"
}

resource "aws_iam_policy" "lambda-update-function" {
  name        = "lambda_udpate_function_${var.env}"
  path        = "/"
  description = "permission to update changelog lambda fuction code"
  policy      = "${data.aws_iam_policy_document.lambda-update-function.json}"
}

resource "aws_iam_policy_attachment" "lambda-update-function" {
  name = "policy_attachment_lambda_update_function_${var.env}"

  roles = [
    "${aws_iam_role.lambda-update-function.name}",
  ]

  policy_arn = "${aws_iam_policy.lambda-update-function.arn}"
}
