provider "aws" {
  version = "~> 1.2"
  region  = "${var.aws_region}"
  profile = "${var.aws_profile}"

  allowed_account_ids = [
    "${var.aws_account_id}",
  ]
}

variable "env" {}

variable "aws_account_id" {}
variable "aws_profile" {}
variable "aws_region" {}

variable "lambda_deploy_aws_profile" {
  default = "twitch-sse-dev"
}

variable "lambda_function_arns" {
  description = "lambda functions we want to give access to deploy to."
  type        = "list"
}

variable "lambda_s3_keys" {
  description = "lambda s3 keys that point to the zip"
  type        = "list"
}

variable "lambda_deploy_user_name" {}
variable "lambda_deploy_user_aws_account_id" {}
variable "s3_bucket_lambda_artifact_arn" {}

output "role_arn" {
  value = "${aws_iam_role.lambda-update-function.arn}"
}
