### sandstorm dev user can assume the above role to deploy lambdas
data "aws_iam_policy_document" "sandstorm-dev-user-assume-role" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    resources = [
      "${var.lambda_deploy_user_assumable_arns}",
    ]

    effect = "Allow"
  }
}

resource "aws_iam_policy" "deploy-user-assume-role" {
  name        = "lambda_deploy_user_assume_role"
  path        = "/"
  description = "assume role to provide permissions to deploy lambda resource"
  policy      = "${data.aws_iam_policy_document.sandstorm-dev-user-assume-role.json}"
}

resource "aws_iam_policy_attachment" "deploy-user-assume-role" {
  name = "policy_attachment_deploy_user_assume_role"

  users = [
    "${var.lambda_deploy_user_name}",
  ]

  policy_arn = "${aws_iam_policy.deploy-user-assume-role.arn}"
}
