resource "aws_dynamodb_table" "sandstorm-audit" {
  name = "sandstorm-${var.env}_audit"

  read_capacity  = "${var.audit_read_capacity}"
  write_capacity = "${var.audit_write_capacity}"

  hash_key  = "name"
  range_key = "updated_at"

  attribute = {
    name = "name"
    type = "S"
  }

  attribute = {
    name = "updated_at"
    type = "N"
  }

  attribute = {
    name = "namespace"
    type = "S"
  }

  global_secondary_index {
    name               = "namespace_name"
    hash_key           = "namespace"
    range_key          = "name"
    write_capacity     = "${var.audit_write_capacity}"
    read_capacity      = "${var.audit_read_capacity}"
    projection_type    = "INCLUDE"
    non_key_attributes = ["updated_at"]
  }

  stream_enabled   = true
  stream_view_type = "NEW_AND_OLD_IMAGES"
}

module "audits-table-backups" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/sse/terraform//modules/dynamodb-cron-backup"

  dynamodb_table_name    = "${aws_dynamodb_table.sandstorm-audit.name}"
  backup_schedule        = "rate(1 day)"
  failure_sns_target_arn = "${aws_sns_topic.pagerduty.arn}"
}
