resource "aws_lambda_function" "cloudwatch-aggregate-sums" {
  function_name = "cloudwatch_aggregate_sums-${var.env}"
  role          = "${aws_iam_role.cloudwatch-aggregate-sums.arn}"
  handler       = "main.aggregate_sums"
  filename      = "${data.archive_file.dummy_lambda.output_path}"
  runtime       = "python3.6"
  timeout       = "300"

  environment {
    variables {
      SANDSTORM_KMS_KEY_ARN = "${aws_kms_key.sandstorm.arn}"
    }
  }

  lifecycle {
    ignore_changes = [
      "filename",
      "s3_bucket",
      "s3_key",
    ]
  }
}

resource "aws_iam_role" "cloudwatch-aggregate-sums" {
  name               = "cloudwatch-aggregate-sums-lambda-${var.env}"
  assume_role_policy = "${data.aws_iam_policy_document.lambda-assume-role.json}"
}

resource "aws_iam_role_policy" "cloudwatch-aggregate-sums" {
  name   = "cloudwatch-aggregate-sums"
  role   = "${aws_iam_role.cloudwatch-aggregate-sums.id}"
  policy = "${data.aws_iam_policy_document.cloudwatch-aggregate-sums-rp.json}"
}

data "aws_iam_policy_document" "cloudwatch-aggregate-sums-rp" {
  statement {
    sid = "Cloudwatch"

    actions = [
      "cloudwatch:GetMetricStatistics",
      "cloudwatch:PutMetricData",
    ]

    resources = [
      "*",
    ]

    effect = "Allow"
  }

  statement {
    sid = "Logging"

    actions = [
      "logs:CreateLogGroup",
      "logs:CreateLogStream",
      "logs:PutLogEvents",
    ]

    resources = [
      "arn:aws:logs:*:*:*",
    ]

    effect = "Allow"
  }
}

module "cloudwatch-aggregate-sums-lambda-cron-trigger" {
  source         = "./lambda-cron-trigger"
  scheduler_name = "${aws_lambda_function.cloudwatch-aggregate-sums.function_name}-hourly"
  function_arn   = "${aws_lambda_function.cloudwatch-aggregate-sums.arn}"
  sns_alarm_arn  = "${aws_sns_topic.pagerduty.arn}"
  schedule       = "rate(1 hour)"
}
