resource "aws_s3_bucket_object" "env-config" {
  bucket  = "${var.lambda_s3_bucket}"
  key     = "sandstorm-configs/${var.env}.hcl"
  content = "${data.template_file.env-config.rendered}"
  acl     = "bucket-owner-full-control"
}

data "template_file" "env-config" {
  template = "${file("${path.module}/sandstorm-config.template")}"

  vars {
    environment               = "${var.env}"
    aws_region                = "${var.region}"
    tablename                 = "${aws_dynamodb_table.sandstorm.name}"
    key_id                    = "alias/sandstorm-${var.env}"
    role_arn                  = "${aws_iam_role.apiserver.arn}"
    rw_aux_policy_arn         = "${aws_iam_policy.aux-rw.arn}"
    aux_policy_arn            = "${aws_iam_policy.aux.arn}"
    topic_arn                 = "${aws_sns_topic.sandstorm.arn}"
    agent_testing_role_arn    = "${var.agent_testing_role_arn}"
    inventory_admin_role_arn  = "${var.inventory_admin_role_arn}"
    inventory_role_arn        = "${var.inventory_role_arn}"
    inventory_status_url      = "${var.inventory_status_url}"
    account_id                = "${var.account_id}"
    sandstorm_table_arn       = "${aws_dynamodb_table.sandstorm.arn}"
    sandstorm_audit_table_arn = "${aws_dynamodb_table.sandstorm-audit.arn}"
    namespaces_table_arn      = "${aws_dynamodb_table.namespaces.arn}"
    role_owners_table_name    = "${aws_dynamodb_table.role-owners.name}"
    cloudwatch_role_arn       = "${aws_iam_role.cloudwatch-metrics.arn}"
  }
}

resource "aws_s3_bucket_object" "env-config-json" {
  bucket = "${var.lambda_s3_bucket}"
  key    = "sandstorm-configs/${var.env}.json"
  acl    = "bucket-owner-full-control"

  content = "${jsonencode(merge(
    map(
      "environment", "${var.env}",
      "aws_region", "${var.region}",
      "table_name", "${aws_dynamodb_table.sandstorm.name}",
      "key_id", "alias/sandstorm-${var.env}",
      "role_arn", "${aws_iam_role.apiserver.arn}",
      "rw_aux_policy_arn", "${aws_iam_policy.aux-rw.arn}",
      "aux_policy_arn", "${aws_iam_policy.aux.arn}",
      "topic_arn", "${aws_sns_topic.sandstorm.arn}",
      "agent_testing_role_arn", "${var.agent_testing_role_arn}",
      "inventory_admin_role_arn", "${var.inventory_admin_role_arn}",
      "inventory_role_arn", "${var.inventory_role_arn}",
      "inventory_status_url", "${var.inventory_status_url}",
      "account_id", "${var.account_id}",
      "sandstorm_table_arn", "${aws_dynamodb_table.sandstorm.arn}",
      "sandstorm_audit_table_arn", "${aws_dynamodb_table.sandstorm-audit.arn}",
      "namespaces_table_arn", "${aws_dynamodb_table.namespaces.arn}",
      "role_owners_table_name", "${aws_dynamodb_table.role-owners.name}",
      "cloudwatch_role_arn", "${aws_iam_role.cloudwatch-metrics.arn}",
    ),
    map(
      "kms_keys", list(
        map(
          "region", "${var.region}",
          "key_arn", "${aws_kms_key.sandstorm.arn}"
        ),
    )),
    map(
      "kms_key", map(
        "region", "${var.region}",
        "key_arn", "${aws_kms_key.sandstorm.arn}"
      ),
    ),
  ))}"
}
