resource "aws_dynamodb_table" "namespaces" {
  name = "sandstorm-${var.env}_namespaces"

  read_capacity  = "${var.namespaces_read_capacity}"
  write_capacity = "${var.namespaces_write_capacity}"

  hash_key = "namespace"

  attribute {
    name = "namespace"
    type = "S"
  }
}

module "namespaces-table-backups" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/sse/terraform//modules/dynamodb-cron-backup"

  dynamodb_table_name    = "${aws_dynamodb_table.namespaces.name}"
  backup_schedule        = "rate(1 day)"
  failure_sns_target_arn = "${aws_sns_topic.pagerduty.arn}"
}

resource "aws_dynamodb_table" "role-owners" {
  name = "sandstorm-${var.env}_role_owners"

  read_capacity  = "${var.role_owners_read_capacity}"
  write_capacity = "${var.role_owners_write_capacity}"

  hash_key = "rolename"

  attribute {
    name = "rolename"
    type = "S"
  }
}

module "role-owners-table-backups" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/sse/terraform//modules/dynamodb-cron-backup"

  dynamodb_table_name    = "${aws_dynamodb_table.role-owners.name}"
  backup_schedule        = "rate(1 day)"
  failure_sns_target_arn = "${aws_sns_topic.pagerduty.arn}"
}
