resource "aws_iam_policy" "aux" {
  name        = "sandstorm-agent-${var.env}-aux"
  path        = "/sandstorm/${var.env}/aux_policy/"
  description = ""
  policy      = "${data.aws_iam_policy_document.aux.json}"
}

resource "aws_iam_policy" "aux-rw" {
  name        = "sandstorm-agent-${var.env}-rw-aux"
  path        = "/sandstorm/${var.env}/aux_policy/"
  description = ""
  policy      = "${data.aws_iam_policy_document.aux-rw.json}"
}

resource "aws_iam_role" "apiserver" {
  name               = "sandstorm-apiserver-${var.env}"
  assume_role_policy = "${data.aws_iam_policy_document.sandstorm-assume-role.json}"
}

resource "aws_iam_policy" "apiserver" {
  name        = "sandstorm-apiserver-${var.env}"
  path        = "/"
  description = "${var.env == "staging" ? "Staging env for sandstorm apiserver" : "" }"
  policy      = "${data.aws_iam_policy_document.apiserver.json}"
}

resource "aws_iam_role" "malachai-apiserver" {
  name               = "malachai-sandstorm-rw-${var.env}"
  assume_role_policy = "${data.aws_iam_policy_document.malachai-service-lambda-arp.json}"
}

resource "aws_iam_policy_attachment" "apiserver" {
  name = "sandstorm-apiserver-attachement-${var.env}"

  roles = [
    "${aws_iam_role.apiserver.name}",
    "${aws_iam_role.malachai-apiserver.name}",
  ]

  policy_arn = "${aws_iam_policy.apiserver.arn}"
}
