resource "aws_cloudwatch_metric_alarm" "lambda-cron-errors" {
  alarm_name          = "${var.scheduler_name}-errors"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = "1"
  metric_name         = "Errors"
  namespace           = "AWS/Lambda"
  period              = "300"
  statistic           = "Sum"
  threshold           = "1"
  alarm_description   = "${var.scheduler_name} scheduler errors"

  alarm_actions = [
    "${var.sns_alarm_arn}",
  ]

  ok_actions = [
    "${var.sns_alarm_arn}",
  ]

  dimensions {
    FunctionName = "${var.function_arn}"
  }
}
