resource "aws_cloudwatch_event_rule" "lambda-cron" {
  name                = "${var.scheduler_name}"
  description         = "${var.scheduler_name} cron execution"
  role_arn            = "${aws_iam_role.lambda-cron.arn}"
  schedule_expression = "${var.schedule}"
}

resource "aws_cloudwatch_event_target" "lambda-cron" {
  target_id = "lambda-cron-${var.scheduler_name}"
  rule      = "${aws_cloudwatch_event_rule.lambda-cron.name}"
  arn       = "${var.function_arn}"
}

resource "aws_lambda_permission" "lambda-cron-cloudwatch" {
  statement_id  = "AllowExecutionFromCloudWatch"
  action        = "lambda:InvokeFunction"
  function_name = "${var.function_arn}"
  principal     = "events.amazonaws.com"
  source_arn    = "${aws_cloudwatch_event_rule.lambda-cron.arn}"
}
