resource "aws_iam_role" "lambda-cron" {
  name               = "${var.scheduler_name}-scheduler"
  assume_role_policy = "${data.aws_iam_policy_document.lambda-cron-arp.json}"
}

data "aws_iam_policy_document" "lambda-cron-arp" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    effect = "Allow"

    principals = {
      type = "Service"

      identifiers = [
        "events.amazonaws.com",
      ]
    }
  }
}

resource "aws_iam_role_policy" "lambda-cron" {
  name   = "${var.scheduler_name}-scheduler"
  role   = "${aws_iam_role.lambda-cron.name}"
  policy = "${data.aws_iam_policy_document.lambda-cron-rp.json}"
}

data "aws_iam_policy_document" "lambda-cron-rp" {
  statement {
    actions = [
      "lambda:InvokeFunction",
    ]

    effect = "Allow"

    resources = [
      "${var.function_arn}",
    ]
  }
}
