variable "region" {
  default = "us-west-2"
}

variable "aws_profile" {}

variable "env" {}

provider "aws" {
  version             = "~> 1.0"
  region              = "${var.region}"
  profile             = "${var.aws_profile}"
  allowed_account_ids = "${var.allowed_account_ids}"
}

provider "aws" {
  alias               = "us-west-1"
  version             = "~> 1.0"
  region              = "us-west-1"
  profile             = "${var.aws_profile}"
  allowed_account_ids = "${var.allowed_account_ids}"
}

variable "allowed_account_ids" {
  type = "list"
}

variable "account_id" {}

variable read_capacity {}
variable write_capacity {}
variable audit_read_capacity {}
variable audit_write_capacity {}
variable namespaces_read_capacity {}
variable namespaces_write_capacity {}
variable role_owners_read_capacity {}
variable role_owners_write_capacity {}

variable lambda_s3_bucket {}

variable changelog_endpoint {}

variable subnet_ids {
  type = "list"
}

variable security_group_ids {
  type = "list"
}

variable pagerduty_webhook_url {}

variable lambda_alarm_period {
  default = "300"
}

variable lambda_alarm_threshold {}

variable apiserver_role_allowed_arns {
  type = "list"
}

variable inventory_execute_api_role_arn {}
variable secret_env {}
variable malachai_service_lambda_role_arn {}

variable inventory_admin_role_arn {
  default = ""
}

variable inventory_role_arn {}
variable inventory_status_url {}

variable agent_testing_role_arn {
  default = ""
}

variable "sandstorm_table_arn" {
  default = ""
}

variable "sandstorm_audit_table_arn" {
  default = ""
}

variable "namespaces_table_arn" {
  default = ""
}

variable "role_owners_table_name" {
  default = ""
}

## locals ##

locals {
  lambda_source_s3_key = "${var.env == "production" ? "production" : var.env == "staging" ? "staging" : "testing"}"
  runbook_url          = "https://wiki.twitch.com/display/SSE/Sandstorm+Runbook"
  kms_tpm_limit        = 198000
}

## Output variables ##
output "apiserver_role_name" {
  value = "${aws_iam_role.apiserver.name}"
}

output "aux_rw_policy_arn" {
  value = "${aws_iam_policy.aux-rw.arn}"
}

output "sandstorm_table" {
  value = "${aws_dynamodb_table.sandstorm.arn}"
}

output "sandstorm_audit_table" {
  value = "${aws_dynamodb_table.sandstorm-audit.arn}"
}

output "sandstorm_namespace_table" {
  value = "${aws_dynamodb_table.namespaces.arn}"
}

output "lambda_function_arns" {
  value = [
    "${aws_lambda_function.sandstorm-lambda.arn}",
    "${aws_lambda_function.cleanup-sns-sqs-subs.arn}",
    "${aws_lambda_function.cloudwatch-aggregate-sums.arn}",

    # changelog lambda
    "${aws_lambda_function.lambda.arn}",
  ]
}

output "lambda_s3_keys" {
  value = [
    "${aws_lambda_function.sandstorm-lambda.s3_key}",
    "${aws_lambda_function.cleanup-sns-sqs-subs.s3_key}",
    "cloudwatch-lambdas/${var.env}.zip",

    # changelog lambda
    "${aws_lambda_function.lambda.s3_key}",
  ]
}

output "config_s3_location" {
  value = "${var.lambda_s3_bucket}/${aws_s3_bucket_object.env-config.id}"
}
