resource "aws_dynamodb_table" "sandstorm" {
  name           = "sandstorm-${var.env}"
  read_capacity  = "${var.read_capacity}"
  write_capacity = "${var.write_capacity}"

  hash_key = "name"

  attribute = {
    name = "name"
    type = "S"
  }

  attribute = {
    name = "namespace"
    type = "S"
  }

  global_secondary_index {
    name            = "namespace_name"
    hash_key        = "namespace"
    range_key       = "name"
    write_capacity  = "${var.write_capacity}"
    read_capacity   = "${var.read_capacity}"
    projection_type = "ALL"
  }

  stream_enabled   = true
  stream_view_type = "NEW_AND_OLD_IMAGES"

  lifecycle {
    ignore_changes = [
      "read_capacity",
      "write_capacity",
      "global_secondary_index",
    ]
  }
}

module "secrets-table-backups" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/sse/terraform//modules/dynamodb-cron-backup"

  dynamodb_table_name    = "${aws_dynamodb_table.sandstorm.name}"
  backup_schedule        = "rate(1 day)"
  failure_sns_target_arn = "${aws_sns_topic.pagerduty.arn}"
}
