data "aws_iam_policy_document" "sandstorm-sns-policy" {
  statement {
    effect = "Allow"

    actions = [
      "SNS:GetTopicAttributes",
      "SNS:SetTopicAttributes",
      "SNS:AddPermission",
      "SNS:RemovePermission",
      "SNS:DeleteTopic",
      "SNS:Subscribe",
      "SNS:ListSubscriptionsByTopic",
      "SNS:Publish",
      "SNS:Receive",
    ]

    condition {
      test     = "StringEquals"
      variable = "AWS:SourceOwner"

      values = [
        "${var.account_id}",
      ]
    }

    resources = [
      "${aws_sns_topic.sandstorm.arn}",
    ]

    principals {
      type        = "AWS"
      identifiers = ["*"]
    }
  }

  policy_id = "__default_policy_ID"
}

resource "aws_sns_topic" "sandstorm" {
  name         = "sandstorm-${var.env}"
  display_name = "sandstorm-${var.env}"
}

resource "aws_sns_topic_policy" "sandstorm" {
  arn    = "${aws_sns_topic.sandstorm.arn}"
  policy = "${data.aws_iam_policy_document.sandstorm-sns-policy.json}"
}
