data "aws_iam_policy_document" "cloudwatch-metrics-arp" {
  statement {
    actions = [
      "sts:AssumeRole",
    ]

    principals {
      type = "AWS"

      identifiers = [
        "arn:aws:iam::${var.account_id}:root",
      ]
    }
  }
}

data "aws_iam_policy_document" "cloudwatch-metrics" {
  statement {
    actions = [
      "cloudwatch:PutMetricData",
      "cloudwatch:GetMetricStatistics",
    ]

    effect = "Allow"

    resources = [
      "*",
    ]
  }
}

resource "aws_iam_role" "cloudwatch-metrics" {
  name               = "sandstorm-cloudwatch-metrics-${var.env}"
  path               = "/sandstorm/aux/"
  assume_role_policy = "${data.aws_iam_policy_document.cloudwatch-metrics-arp.json}"
  description        = "write access to cloudwatch stats for apiserver and manager"
}

resource "aws_iam_role_policy" "cloudwatch-metrics" {
  name   = "sandstorm-cloudwatch-metrics"
  role   = "${aws_iam_role.cloudwatch-metrics.id}"
  policy = "${data.aws_iam_policy_document.cloudwatch-metrics.json}"
}
