module "anichaur" {
  source         = "../modules"
  env            = "anichaur"
  secret_env     = "anichaur"
  aws_profile    = "twitch-sandstorm-dev"
  account_id     = 505345203727
  read_capacity  = 100
  write_capacity = 100

  allowed_account_ids = ["505345203727"]

  audit_read_capacity  = 100
  audit_write_capacity = 100

  namespaces_read_capacity   = 100
  namespaces_write_capacity  = 100
  role_owners_read_capacity  = 5
  role_owners_write_capacity = 5

  lambda_alarm_threshold = 5
  changelog_endpoint     = "https://changelog-staging.internal.justin.tv"
  lambda_s3_bucket       = "sse-sandstorm"
  pagerduty_webhook_url  = "https://events.pagerduty.com/integration/073f5582f61f471eb500d5a3f5c14a7a/enqueue"

  apiserver_role_allowed_arns = [
    "arn:aws:iam::734326455073:root",
    "arn:aws:iam::673385534282:root",
    "arn:aws:iam::289423984879:root",
    "arn:aws:iam::516651178292:root",
    "arn:aws:iam::854594403332:root",
  ]

  security_group_ids = ["sg-59e0cd22"]
  subnet_ids         = ["subnet-a44f9bff", "subnet-37ecae7e", "subnet-6b341e0c"]

  inventory_execute_api_role_arn   = "arn:aws:iam::516651178292:role/inventory-gateway-execute-api-invoke-anichaur"
  malachai_service_lambda_role_arn = "arn:aws:iam::289423984879:role/malachai-service-lambda-testing"

  inventory_admin_role_arn = "arn:aws:iam::516651178292:role/inventory-admin-anichaur"
  inventory_role_arn       = "arn:aws:iam::516651178292:role/inventory-gateway-execute-api-invoke-anichaur"
  agent_testing_role_arn   = "${module.testing-role-anichaur.agent_role_arn}"
  inventory_status_url     = "https://o1ll5pv4hh.execute-api.us-west-2.amazonaws.com/anichaur"
}

module "testing-role-anichaur" {
  source                    = "../sandstorm_testing"
  aws_profile               = "twitch-sandstorm-dev"
  region                    = "us-west-2"
  account_id                = 505345203727
  env                       = "anichaur"
  trusted_account_ids       = ["516651178292", "734326455073"]
  aux_rw_policy_arn         = "${module.anichaur.aux_rw_policy_arn}"
  apiserver_role_name       = "${module.anichaur.apiserver_role_name}"
  sandstorm_table           = "${module.anichaur.sandstorm_table}"
  sandstorm_audit_table     = "${module.anichaur.sandstorm_audit_table}"
  sandstorm_namespace_table = "${module.anichaur.sandstorm_namespace_table}"
}
