module "production" {
  source               = "./modules"
  env                  = "production"
  secret_env           = "*"
  aws_profile          = "twitch-sandstorm-infra-aws"
  account_id           = 734326455073
  read_capacity        = 2500
  write_capacity       = 100
  audit_read_capacity  = 1000
  audit_write_capacity = 100

  lambda_alarm_threshold = 10
  changelog_endpoint     = "https://changelog.internal.justin.tv"
  lambda_s3_bucket       = "${module.deployment.lambda_s3_bucket}"
  pagerduty_webhook_url  = "https://events.pagerduty.com/integration/b7544d72fd934f78b4ff5e7d32493759/enqueue"

  allowed_account_ids = [
    "734326455073",
  ]

  namespaces_read_capacity   = 1000
  namespaces_write_capacity  = 100
  role_owners_read_capacity  = 100
  role_owners_write_capacity = 10

  apiserver_role_allowed_arns = [
    "arn:aws:iam::584671007337:role/TF-sandstorm-apiserver-production",
    "arn:aws:iam::673385534282:root",
  ]

  subnet_ids         = ["subnet-e869fd8e", "subnet-63c59838", "subnet-752e9b3d"]
  security_group_ids = ["sg-8e2baef3"]

  inventory_execute_api_role_arn = "arn:aws:iam::854594403332:role/inventory-gateway-execute-api-invoke-production"

  malachai_service_lambda_role_arn = "arn:aws:iam::180116294062:role/malachai-service-lambda-production"

  inventory_role_arn   = "arn:aws:iam::854594403332:role/inventory-gateway-execute-api-invoke-production"
  inventory_status_url = "https://zhpqn2llm0.execute-api.us-west-2.amazonaws.com/production"
}
