module "staging" {
  source         = "./modules"
  env            = "staging"
  secret_env     = "staging"
  aws_profile    = "twitch-sandstorm-dev"
  account_id     = 505345203727
  read_capacity  = 100
  write_capacity = 100

  allowed_account_ids = ["505345203727"]

  audit_read_capacity  = 100
  audit_write_capacity = 100

  namespaces_read_capacity   = 100
  namespaces_write_capacity  = 100
  role_owners_read_capacity  = 5
  role_owners_write_capacity = 5

  lambda_alarm_threshold = 5
  changelog_endpoint     = "https://changelog-staging.internal.justin.tv"
  lambda_s3_bucket       = "${module.deployment.lambda_s3_bucket}"
  pagerduty_webhook_url  = "https://events.pagerduty.com/integration/073f5582f61f471eb500d5a3f5c14a7a/enqueue"

  apiserver_role_allowed_arns = [
    "arn:aws:iam::673385534282:role/sandstorm-staging-rw",
    "arn:aws:iam::505345203727:role/TF-sandstorm-apiserver-staging",
  ]

  security_group_ids = ["sg-59e0cd22"]
  subnet_ids         = ["subnet-a44f9bff", "subnet-37ecae7e", "subnet-6b341e0c"]

  inventory_execute_api_role_arn = "arn:aws:iam::516651178292:role/inventory-gateway-execute-api-invoke-staging"

  malachai_service_lambda_role_arn = "arn:aws:iam::289423984879:root"

  inventory_admin_role_arn = "arn:aws:iam::516651178292:role/inventory-admin-staging"
  inventory_role_arn       = "arn:aws:iam::516651178292:role/inventory-gateway-execute-api-invoke-staging"
  inventory_status_url     = "https://6a1q09fvs9.execute-api.us-west-2.amazonaws.com/staging"
}
