# [Overview Doc](https://docs.google.com/document/d/1j4Psq2ejU2Yv1RVaX22Gbu_abIQX_hOW5wJsuMTb3N0/edit?usp=sharing)

[![codecov](https://codecov.internal.justin.tv/ghe/COOLORGNAME/COOLREPONAME/branch/master/graph/badge.svg)](https://codecov.internal.justin.tv/ghe/COOLORGNAME/COOLREPONAME) [![Go Report Card](https://goreportcard.internal.justin.tv/badge/code.justin.tv/COOLORGNAME/COOLREPONAME)](https://goreportcard.internal.justin.tv/report/code.justin.tv/COOLORGNAME/COOLREPONAME)

# VODApi - VOD metadata service

## Development

### Development and deployment workflow

- Run ./scripts/setup_githooks to install the githooks.

### Testing

Unit tests are run with:

	make test

Static checks are run with:

	make quality

You can also use:

	make local_checks

to run build, quality, unit tests, and code coverage checks (not uploading to CodeCov) to make sure your code is in a good state. This is what the `pre-commit` hook does.

Integration tests are run with:

	make test_integration_staging

and

	make test_integration_production


Unit tests follow the golang standard of keeping the test files close to the source files.

As you add more clients (`pkg`s), you'll likely need to add more mocks. You might need to edit `Makefile` to make sure your new client has a mock generated. Mocks are generated via [mockery](https://github.com/vektra/mockery). To generate the new mocks, run:

	make mocks

When you need to update the RPC (twirp) definitions, run:

	make generate

There are integrations tests for running against the endpoint directly as well as through Visage.

### Dependencies

VODApi uses [dep](https://github.com/golang/dep) to manage dependencies. To upgrade package, edit the [Gopkg.toml file](/Gopkg.toml) and run

	make ensure_deps

### Standard Twitch Libraries

	"github.com/twitchtv/twirp"
	"code.justin.tv/common/config"
    "code.justin.tv/common/chitin"
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/foundation/twitchserver"

### App Structure

##### Internal Folders (internal)
- auth
- backend
- datastore
- errors
- models
- server
- tracker

##### "Public" Folders (pkg)
- errorlogger
- shared
- spade
- utils

### Error Logging

VODApi contains a wrapper around rollbar error logger, attempting to follow the Amazon Sev-1, 2, 2.5, 3, 4, 5 guidelines.
- Fatal errors: anything that will/should kill the server. These should be treated as a Sev-1 - something that has taken down your app. This will probably be triggered via AWS metrics, and most likely not from error logging. However, if you are handling an error that will be fatal and is something that needs to be addressed immediately and killing the server makes sense, use `LogFatal`/`LogFatalWithExtras`, which will trigger pages & should likely wake the entire team.
- An error that blocks large portions of functionality should be treated as a Sev-2 - something that prevents new records from being created, or existing ones being modified. Downstream services going down, unknown errors reading/writing from/to DynamoDB, etc. would be Sev-2's. Use `LogError`/`LogErrorWithExtras`, which should trigger pages and need to be assessed and resolved.
- An error that degrades functionality significantly should be treated as a Sev-2.5/3 - something that on a per-user/stream basis has degraded functionality. A downstream service having an increased error rate leading to missing data on records would be an example. Use `LogWarn`/`LogWarnWithExtras`, which should trigger pages but don't need to be addressed until the next business day or later. Each new issue is raised as a Sev-2.5, and then downgraded to Sev-3 as appropriate.
- An issue that likely cannot be controlled/fixed should be treated as a Sev-4 - low priority. A user trying to delete items that aren't in a record, etc. are of this type. Use `LogInfo`/`LogInfoWithExtras`, which will not trigger a page.
- For things that aren't errors but are to be logged, use `LogDebug`/`LogDebugWithExtras` or just use stats.

## F.A.Q.s

### How to create a dev environment?

Make sure your branch is already on github. Then run this script (when you've checked out the branch to deploy):

	./scripts/create_dev_pipeline_from_branch

You might need to push a noop commit to github.

When you're done, make sure to run:

	./scripts/destroy_dev_pipeline_from_branch
