package main

import (
	"testing"

	"code.justin.tv/common/config"
	"code.justin.tv/vod/vodapi/internal/auth"
	"code.justin.tv/vod/vodapi/internal/server"
	. "github.com/smartystreets/goconvey/convey"
)

func TestMain(t *testing.T) {
	conf, _ := loadJSONConfig("../../configs/vodapi.json", "development")
	config.Register(conf)

	// Most of this is testing that the basic setup calls in main arent' invalid
	// or leading to immediate/fatal crashes.
	Convey("Testing main", t, func() {
		statter := config.ClusterStatsd()

		So(conf, ShouldNotResemble, map[string]string{})

		Convey("when configuring error logger", func() {
			_ = configureErrorLogger("", statter)
		})
		Convey("when configuring hystrix", func() {
			configureHystrix()
		})
		Convey("when configuring statter", func() {
			configureStatter()
		})
		Convey("when configuring secrets manager", func() {
			_, err := configureSecretsManager()
			So(err, ShouldBeNil)
		})
		Convey("when configuring backend", func() {
			logger := configureErrorLogger("", statter)
			vinyl, _ := configureVinyl()
			backend, err := configureBackend(logger, statter, vinyl)
			So(err, ShouldBeNil)
			So(backend, ShouldNotBeNil)
		})
		Convey("when configuring server", func() {
			auth := auth.NewFakeHandler(true)
			logger := configureErrorLogger("", statter)
			vinyl, _ := configureVinyl()
			backend, _ := configureBackend(logger, statter, vinyl)
			server := server.NewServer(auth, backend, logger, statter)
			So(server, ShouldNotBeNil)
		})
	})
}
