package auth

import (
	"fmt"
	"net/http"
	"strings"

	"code.justin.tv/vod/vodapi/pkg/shared"
)

type jwtHandler struct {
}

// NewJWTHandler creates a new JWT handler.
func NewJWTHandler() (Handler, error) {
	return &jwtHandler{}, nil
}

// AuthMiddleware runs on every request.
func (j *jwtHandler) AuthMiddleware(h http.Handler) http.Handler {
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		serializedToken := r.Header.Get("Twitch-Authorization")
		ctx := shared.ContextWithAuthToken(r.Context(), serializedToken)
		h.ServeHTTP(w, r.WithContext(ctx))
	})
}

// formatRequest generates ascii representation of a request
func formatRequest(r *http.Request) string {
	// Create return string
	var request []string
	// Add the request string
	url := fmt.Sprintf("%v %v %v", r.Method, r.URL, r.Proto)
	request = append(request, url)
	// Add the host
	request = append(request, fmt.Sprintf("Host: %v", r.Host))
	// Loop through headers
	for name, headers := range r.Header {
		name = strings.ToLower(name)
		for _, h := range headers {
			request = append(request, fmt.Sprintf("%v: %v", name, h))
		}
	}

	// If this is a POST, add post data
	if r.Method == "POST" {
		if r.ParseForm() != nil {
			request = append(request, "\n")
			request = append(request, r.Form.Encode())
		}
	}
	// Return the request as a string
	return strings.Join(request, "\n")
}
