package backend

import (
	"testing"

	"github.com/cactus/go-statsd-client/statsd"
	"github.com/stretchr/testify/mock"

	trackerMock "code.justin.tv/vod/vodapi/internal/tracker/mocks"
	errorloggerMock "code.justin.tv/vod/vodapi/pkg/errorlogger/mocks"
	vinylMock "code.justin.tv/vod/vodapi/pkg/vinyl/mocks"
)

type backendMockClients interface {
	AssertExpectations(t *testing.T)
}

type backendMockClientsImpl struct {
	errorlogger *errorloggerMock.ErrorLogger
	tracker     *trackerMock.Tracker
	vinyl       *vinylMock.Client
	// TODO add ability to mock statter
	// stats                statsd.Statter
}

func initTestableBackend() (*backendImpl, *backendMockClientsImpl) {
	stats, _ := statsd.NewNoopClient()
	errorlogger := &errorloggerMock.ErrorLogger{}
	tracker := &trackerMock.Tracker{}
	vinyl := &vinylMock.Client{}
	return &backendImpl{
			errorlogger,
			stats,
			tracker,
			vinyl,
		}, &backendMockClientsImpl{
			errorlogger,
			tracker,
			vinyl,
		}
}

func (b *backendMockClientsImpl) MockErrorHandle() {
	b.errorlogger.On("LogErrorWithExtras", mock.Anything, mock.Anything, mock.Anything)
}

func (b *backendMockClientsImpl) AssertExpectations(t *testing.T) {
	b.errorlogger.AssertExpectations(t)
	b.tracker.AssertExpectations(t)
	b.vinyl.AssertExpectations(t)
}
