package converters

import (
	"strconv"

	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/models"
	vinylWrapper "code.justin.tv/vod/vodapi/pkg/vinyl"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// ConvertInternalToVinylCreateAppeals converts internal to vinyl model
func ConvertInternalToVinylCreateAppeals(createAppeals *models.ManagerCreateVodAppealsRequest) vinyl.CreateAppealsInput {
	trackAppeals := make([]vinyl.TrackAppeal, len(createAppeals.TrackAppeals))
	for i, trackAppeal := range createAppeals.TrackAppeals {
		trackAppeals[i] = vinyl.TrackAppeal{
			AudibleMagicResponseID: trackAppeal.AudibleMagicResponseID,
			Reason:                 trackAppeal.Reason,
		}
	}
	return vinyl.CreateAppealsInput{
		VodID: strconv.FormatInt(createAppeals.VodID, 10),
		VodAppeal: vinyl.VodAppeal{
			City:           createAppeals.City,
			Country:        createAppeals.Country,
			FullName:       createAppeals.FullName,
			State:          createAppeals.State,
			StreetAddress1: createAppeals.StreetAddress1,
			StreetAddress2: createAppeals.StreetAddress2,
			Zipcode:        createAppeals.Zipcode,
		},
		TrackAppeals: trackAppeals,
	}
}

// ConvertVinylAppealsResponse converts vinyl to internal model
func ConvertVinylAppealsResponse(appealsResponse *vinylWrapper.GetAppealsResponse) *models.VodAppealsResponse {
	appeals := make([]models.VodAppeal, len(appealsResponse.Appeals))
	for i, appeal := range appealsResponse.Appeals {
		appeals[i] = models.VodAppeal{
			VodAppealID:    appeal.ID,
			ResolvedAt:     appeal.ResolvedAt,
			CreatedAt:      appeal.CreatedAt,
			UpdatedAt:      appeal.UpdatedAt,
			VodID:          appeal.VodID,
			Priority:       appeal.Priority,
			FullName:       appeal.FullName,
			StreetAddress1: appeal.StreetAddress1,
			StreetAddress2: appeal.StreetAddress2,
			City:           appeal.City,
			State:          appeal.State,
			Zipcode:        appeal.Zipcode,
			Country:        appeal.Country,
		}
	}
	return &models.VodAppealsResponse{
		TotalCount: appealsResponse.TotalCount,
		Appeals:    appeals,
	}
}

// ConvertInternalToVinylCreateAudibleMagicResponse converts internal to vinyl model
func ConvertInternalToVinylCreateAudibleMagicResponse(audibleMagicResponse models.CreateAudibleMagicResponseRequest) vinyl.CreateAMRInput {
	return vinyl.CreateAMRInput{
		VodID:                audibleMagicResponse.VodID,
		Title:                audibleMagicResponse.Title,
		Performer:            audibleMagicResponse.Performer,
		Genre:                audibleMagicResponse.Genre,
		Artist:               audibleMagicResponse.Artist,
		AlbumTitle:           audibleMagicResponse.AlbumTitle,
		Song:                 audibleMagicResponse.Song,
		Isrc:                 audibleMagicResponse.Isrc,
		MatchOffsetSeconds:   audibleMagicResponse.MatchOffsetSeconds,
		MatchDurationSeconds: audibleMagicResponse.MatchDurationSeconds,
		ScanOffsetSeconds:    audibleMagicResponse.ScanOffsetSeconds,
		ScanDurationSeconds:  audibleMagicResponse.ScanDurationSeconds,
		MuteOffsetSeconds:    audibleMagicResponse.MuteOffsetSeconds,
		MuteDurationSeconds:  audibleMagicResponse.MuteDurationSeconds,
		AmItemID:             audibleMagicResponse.AudibleMagicItemID,
	}
}

// ConvertInternalToVinylUpdateAudibleMagicResponse converts internal to vinyl
func ConvertInternalToVinylUpdateAudibleMagicResponse(updateAudibleMagicResponse *models.UpdateAudibleMagicResponsesRequest) *vinylWrapper.UpdateAudibleMagicResponsesInput {
	audibleMagicResponses := make([]vinylWrapper.UpdateAudibleMagicResponse, len(updateAudibleMagicResponse.UpdateAudibleMagicResponses))
	for i, audibleMagicResponse := range updateAudibleMagicResponse.UpdateAudibleMagicResponses {
		audibleMagicResponses[i] = vinylWrapper.UpdateAudibleMagicResponse{
			AudibleMagicResponseID: audibleMagicResponse.AudibleMagicResponseID,
			Title:                audibleMagicResponse.Title,
			Performer:            audibleMagicResponse.Performer,
			Genre:                audibleMagicResponse.Genre,
			Artist:               audibleMagicResponse.Artist,
			AlbumTitle:           audibleMagicResponse.AlbumTitle,
			Song:                 audibleMagicResponse.Song,
			Isrc:                 audibleMagicResponse.Isrc,
			IsMatch:              audibleMagicResponse.IsMatch,
			MatchOffsetSeconds:   audibleMagicResponse.MatchOffsetSeconds,
			MatchDurationSeconds: audibleMagicResponse.MatchDurationSeconds,
			ScanOffsetSeconds:    audibleMagicResponse.ScanOffsetSeconds,
			ScanDurationSeconds:  audibleMagicResponse.ScanDurationSeconds,
			MuteOffsetSeconds:    audibleMagicResponse.MuteOffsetSeconds,
			MuteDurationSeconds:  audibleMagicResponse.MuteDurationSeconds,
			AmItemID:             audibleMagicResponse.AudibleMagicItemID,
		}
	}
	return &vinylWrapper.UpdateAudibleMagicResponsesInput{
		UpdateAudibleMagicResponses: audibleMagicResponses,
	}
}

// ConvertVinylAudibleMagicResponses converts vinyl to internal model
func ConvertVinylAudibleMagicResponses(amrs []*vinyl.AMR) *models.AudibleMagicResponsesResponse {
	audibleMagicResponses := make([]models.AudibleMagicResponse, len(amrs))
	for i, amr := range amrs {
		audibleMagicResponses[i] = models.AudibleMagicResponse{
			AudibleMagicResponseID: amr.AudibleMagicResponseID,
			VodID:                amr.VodID,
			Title:                utils.ConvertStrPtrToStr(amr.Title),
			Performer:            utils.ConvertStrPtrToStr(amr.Performer),
			Genre:                utils.ConvertStrPtrToStr(amr.Genre),
			Artist:               utils.ConvertStrPtrToStr(amr.Artist),
			AlbumTitle:           utils.ConvertStrPtrToStr(amr.AlbumTitle),
			Song:                 utils.ConvertStrPtrToStr(amr.Song),
			Isrc:                 utils.ConvertStrPtrToStr(amr.Isrc),
			IsMatch:              amr.IsMatch,
			MatchOffsetSeconds:   amr.MatchOffsetSeconds,
			MatchDurationSeconds: amr.MatchDurationSeconds,
			ScanOffsetSeconds:    amr.ScanOffsetSeconds,
			ScanDurationSeconds:  amr.ScanDurationSeconds,
			MuteOffsetSeconds:    amr.MuteOffsetSeconds,
			MuteDurationSeconds:  amr.MuteDurationSeconds,
			AudibleMagicItemID:   utils.ConvertStrPtrToStr(amr.AmItemID),
			CreatedAt:            amr.CreatedAt,
			UpdatedAt:            amr.UpdatedAt,
			SongLength:           utils.ConvertInt64PtrToInt64(amr.SongLength),
			UnmutedAt:            amr.UnmutedAt,
		}
	}
	return &models.AudibleMagicResponsesResponse{
		AudibleMagicResponses: audibleMagicResponses,
	}
}
