package converters

import (
	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
)

// ConvertMuteInfo converts Mute info from vinyl to internal model
func ConvertMuteInfo(vinylVod *vinyl.Vod) *models.VodMuteInfoResponse {
	audibleMagicResponses := make([]models.AudibleMagicResponse, len(vinylVod.AudibleMagicResponses))
	for i, audibleMagicResponse := range vinylVod.AudibleMagicResponses {
		audibleMagicResponses[i] = models.AudibleMagicResponse{
			AudibleMagicResponseID: audibleMagicResponse.AudibleMagicResponseID,
			VodID:                audibleMagicResponse.VodID,
			Title:                utils.ConvertStrPtrToStr(audibleMagicResponse.Title),
			Performer:            utils.ConvertStrPtrToStr(audibleMagicResponse.Performer),
			Genre:                utils.ConvertStrPtrToStr(audibleMagicResponse.Genre),
			Artist:               utils.ConvertStrPtrToStr(audibleMagicResponse.Artist),
			AlbumTitle:           utils.ConvertStrPtrToStr(audibleMagicResponse.AlbumTitle),
			Song:                 utils.ConvertStrPtrToStr(audibleMagicResponse.Song),
			Isrc:                 utils.ConvertStrPtrToStr(audibleMagicResponse.Isrc),
			IsMatch:              audibleMagicResponse.IsMatch,
			MatchOffsetSeconds:   audibleMagicResponse.MatchOffsetSeconds,
			MatchDurationSeconds: audibleMagicResponse.MatchDurationSeconds,
			ScanOffsetSeconds:    audibleMagicResponse.ScanOffsetSeconds,
			ScanDurationSeconds:  audibleMagicResponse.ScanDurationSeconds,
			MuteOffsetSeconds:    audibleMagicResponse.MuteOffsetSeconds,
			MuteDurationSeconds:  audibleMagicResponse.MuteDurationSeconds,
			AudibleMagicItemID:   utils.ConvertStrPtrToStr(audibleMagicResponse.AmItemID),
			CreatedAt:            audibleMagicResponse.CreatedAt,
			UnmutedAt:            audibleMagicResponse.UnmutedAt,
		}
	}

	mutedSegments := make([]models.VodMutedSegment, len(vinylVod.MutedSegments))
	for i, mutedSegment := range vinylVod.MutedSegments {
		mutedSegments[i] = models.VodMutedSegment{
			Offset:   int64(mutedSegment.Offset),
			Duration: int64(mutedSegment.Duration),
		}
	}

	var vodAppeal models.VodAppeal
	if vinylVod.VodAppeal != nil {
		vodAppeal = models.VodAppeal{
			VodAppealID:    vinylVod.VodAppeal.VodAppealID,
			ResolvedAt:     vinylVod.VodAppeal.ResolvedAt,
			CreatedAt:      vinylVod.VodAppeal.CreatedAt,
			UpdatedAt:      vinylVod.VodAppeal.UpdatedAt,
			VodID:          vinylVod.VodAppeal.VodID,
			Priority:       vinylVod.VodAppeal.Priority,
			FullName:       vinylVod.VodAppeal.FullName,
			StreetAddress1: vinylVod.VodAppeal.StreetAddress1,
			StreetAddress2: vinylVod.VodAppeal.StreetAddress2,
			City:           vinylVod.VodAppeal.City,
			State:          vinylVod.VodAppeal.State,
			Zipcode:        vinylVod.VodAppeal.Zipcode,
			Country:        vinylVod.VodAppeal.Country,
		}
	}

	trackAppeals := make([]models.TrackAppeal, len(vinylVod.TrackAppeals))
	for i, trackAppeal := range vinylVod.TrackAppeals {
		trackAppeals[i] = models.TrackAppeal{
			TrackAppealID:          trackAppeal.TrackAppealID,
			AudibleMagicResponseID: trackAppeal.AudibleMagicResponseID,
			VodAppealID:            trackAppeal.VodAppealID,
			Reason:                 trackAppeal.Reason,
			CreatedAt:              trackAppeal.CreatedAt,
			UpdatedAt:              trackAppeal.UpdatedAt,
			ResolvedAt:             trackAppeal.ResolvedAt,
		}
	}

	return &models.VodMuteInfoResponse{
		ID: vinylVod.ID,
		AudibleMagicResponses: audibleMagicResponses,
		MutedSegments:         mutedSegments,
		VodAppeal:             vodAppeal,
		TrackAppeals:          trackAppeals,
		IsMuted:               vinylVod.IsMuted,
		CanCreateAppeal:       vinylVod.CanCreateAppeal,
		HasPendingAppeal:      vinylVod.HasPendingAppeal,
	}
}

// ConvertMuteInfos converts Mute infos from vinyl to internal model
func ConvertMuteInfos(vinylVods []*vinyl.Vod) []*models.VodMuteInfoResponse {
	resp := make([]*models.VodMuteInfoResponse, len(vinylVods))
	for i, vod := range vinylVods {
		resp[i] = ConvertMuteInfo(vod)
	}
	return resp
}
