package converters

import (
	"testing"
	"time"

	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
)

func TestMuteInfo(t *testing.T) {
	Convey("when using mute info convertesr", t, func() {
		utils.StubTimeNow()

		Convey("when converting mute info", func() {
			isMuted := true
			canCreateAppeal := true
			hasPendingAppeal := true

			input := &vinyl.Vod{
				ID: 8888,
				AudibleMagicResponses: []vinyl.AMR{
					vinyl.AMR{
						AudibleMagicResponseID: 2345,
						VodID:                3456,
						Title:                utils.StrPtr("title"),
						Performer:            utils.StrPtr("performer"),
						Genre:                utils.StrPtr("genre"),
						Artist:               utils.StrPtr("artist"),
						AlbumTitle:           utils.StrPtr("album_title"),
						Song:                 utils.StrPtr("song"),
						Isrc:                 utils.StrPtr("isrc"),
						IsMatch:              true,
						MatchOffsetSeconds:   utils.Int64Ptr(10),
						MatchDurationSeconds: utils.Int64Ptr(20),
						ScanOffsetSeconds:    utils.Int64Ptr(30),
						ScanDurationSeconds:  utils.Int64Ptr(40),
						MuteOffsetSeconds:    utils.Int64Ptr(50),
						MuteDurationSeconds:  utils.Int64Ptr(60),
						AmItemID:             utils.StrPtr("item_id"),
						CreatedAt:            time.Now(),
						UnmutedAt:            utils.TimePtr(time.Now()),
					},
				},
				MutedSegments: []vinyl.VodMutedSegment{
					vinyl.VodMutedSegment{
						Offset:   10,
						Duration: 20,
					},
				},
				VodAppeal: &vinyl.VodAppeal{
					VodAppealID:    1234,
					CreatedAt:      time.Now(),
					UpdatedAt:      time.Now(),
					VodID:          2345,
					Priority:       true,
					FullName:       "full_name",
					StreetAddress1: "street_address1",
					StreetAddress2: "street_address2",
					City:           "city",
					State:          "state",
					Zipcode:        "zipcode",
					Country:        "country",
				},
				TrackAppeals: []vinyl.TrackAppeal{
					vinyl.TrackAppeal{
						TrackAppealID:          7777,
						AudibleMagicResponseID: 8888,
						VodAppealID:            9999,
						Reason:                 "reason",
						CreatedAt:              time.Now(),
						UpdatedAt:              time.Now(),
					},
				},
				IsMuted:          &isMuted,
				CanCreateAppeal:  &canCreateAppeal,
				HasPendingAppeal: &hasPendingAppeal,
			}
			output := &models.VodMuteInfoResponse{
				ID: 8888,
				AudibleMagicResponses: []models.AudibleMagicResponse{
					models.AudibleMagicResponse{
						AudibleMagicResponseID: input.AudibleMagicResponses[0].AudibleMagicResponseID,
						VodID:                input.AudibleMagicResponses[0].VodID,
						Title:                *input.AudibleMagicResponses[0].Title,
						Performer:            *input.AudibleMagicResponses[0].Performer,
						Genre:                *input.AudibleMagicResponses[0].Genre,
						Artist:               *input.AudibleMagicResponses[0].Artist,
						AlbumTitle:           *input.AudibleMagicResponses[0].AlbumTitle,
						Song:                 *input.AudibleMagicResponses[0].Song,
						Isrc:                 *input.AudibleMagicResponses[0].Isrc,
						IsMatch:              input.AudibleMagicResponses[0].IsMatch,
						MatchOffsetSeconds:   input.AudibleMagicResponses[0].MatchOffsetSeconds,
						MatchDurationSeconds: input.AudibleMagicResponses[0].MatchDurationSeconds,
						ScanOffsetSeconds:    input.AudibleMagicResponses[0].ScanOffsetSeconds,
						ScanDurationSeconds:  input.AudibleMagicResponses[0].ScanDurationSeconds,
						MuteOffsetSeconds:    input.AudibleMagicResponses[0].MuteOffsetSeconds,
						MuteDurationSeconds:  input.AudibleMagicResponses[0].MuteDurationSeconds,
						AudibleMagicItemID:   *input.AudibleMagicResponses[0].AmItemID,
						CreatedAt:            input.AudibleMagicResponses[0].CreatedAt,
						UnmutedAt:            input.AudibleMagicResponses[0].UnmutedAt,
					},
				},
				MutedSegments: []models.VodMutedSegment{
					models.VodMutedSegment{
						Offset:   10,
						Duration: 20,
					},
				},
				VodAppeal: models.VodAppeal{
					VodAppealID:    input.VodAppeal.VodAppealID,
					CreatedAt:      input.VodAppeal.CreatedAt,
					UpdatedAt:      input.VodAppeal.UpdatedAt,
					VodID:          input.VodAppeal.VodID,
					Priority:       input.VodAppeal.Priority,
					FullName:       input.VodAppeal.FullName,
					StreetAddress1: input.VodAppeal.StreetAddress1,
					StreetAddress2: input.VodAppeal.StreetAddress2,
					City:           input.VodAppeal.City,
					State:          input.VodAppeal.State,
					Zipcode:        input.VodAppeal.Zipcode,
					Country:        input.VodAppeal.Country,
				},
				TrackAppeals: []models.TrackAppeal{
					models.TrackAppeal{
						TrackAppealID:          input.TrackAppeals[0].TrackAppealID,
						AudibleMagicResponseID: input.TrackAppeals[0].AudibleMagicResponseID,
						VodAppealID:            input.TrackAppeals[0].VodAppealID,
						Reason:                 input.TrackAppeals[0].Reason,
						CreatedAt:              input.TrackAppeals[0].CreatedAt,
						UpdatedAt:              input.TrackAppeals[0].UpdatedAt,
					},
				},
				IsMuted:          &isMuted,
				CanCreateAppeal:  &canCreateAppeal,
				HasPendingAppeal: &hasPendingAppeal,
			}
			So(output, ShouldResemble, ConvertMuteInfo(input))
		})
	})
}
