package converters

import (
	"strconv"

	"code.justin.tv/vod/vodapi/internal/models"
)

// ConvertVinylShowFormats converts from vinyl to to internal models
func ConvertVinylShowFormats(showFormats map[string]map[string]interface{}) map[string]models.ShowFormat {
	result := map[string]models.ShowFormat{}
	for formatKey, showMap := range showFormats {
		showFormat := models.ShowFormat{}
		for key, val := range showMap {
			switch key {
			case "playlist_preference":
				switch v := val.(type) {
				case int64:
					showFormat.PlaylistPreference = v
				case int:
					showFormat.PlaylistPreference = int64(v)
				case float64:
					pVal := val.(float64)
					showFormat.PlaylistPreference = int64(pVal)
				}
			case "display_name":
				if d, ok := val.(string); ok {
					showFormat.DisplayName = d
				}
			case "bitrate":
				switch v := val.(type) {
				case int64:
					showFormat.Bitrate = v
				case int:
					showFormat.Bitrate = int64(v)
				case float64:
					bVal := val.(float64)
					showFormat.Bitrate = int64(bVal)
				}
			case "max_idr_interval":
				switch v := val.(type) {
				case int64:
					showFormat.MaxIdrInterval = v
				case int:
					showFormat.MaxIdrInterval = int64(v)
				case float64:
					bVal := val.(float64)
					showFormat.MaxIdrInterval = int64(bVal)
				}
			case "fps":
				switch v := val.(type) {
				case string:
					fVal, err := strconv.ParseFloat(v, 64)
					if err != nil {
						continue
					}
					showFormat.Fps = fVal
				case int:
					showFormat.Fps = float64(v)
				case float64:
					showFormat.Fps = v
				}
			case "codecs":
				if c, ok := val.(string); ok {
					showFormat.Codecs = c
				}
			case "resolution":
				if r, ok := val.(string); ok {
					showFormat.Resolution = r
				}
			}
		}
		result[formatKey] = showFormat
	}
	return result
}

// ConvertToVinylShowFormats converts from internal vinyl models
func ConvertToVinylShowFormats(showFormats map[string]models.ShowFormat) *map[string]map[string]interface{} {
	result := make(map[string]map[string]interface{}, len(showFormats))
	for formatKey, showFormat := range showFormats {
		result[formatKey] = map[string]interface{}{
			"playlist_preference": showFormat.PlaylistPreference,
			"display_name":        showFormat.DisplayName,
			"bitrate":             showFormat.Bitrate,
			"fps":                 showFormat.Fps,
			"max_idr_interval":    showFormat.MaxIdrInterval,
			"codecs":              showFormat.Codecs,
			"resolution":          showFormat.Resolution,
		}
	}
	return &result
}
