package converters_test

import (
	"testing"

	"code.justin.tv/vod/vodapi/internal/backend/converters"
	"code.justin.tv/vod/vodapi/internal/models"
	"github.com/stretchr/testify/assert"
)

func TestConvertVinylShowFormats(t *testing.T) {
	assert.Equal(t, map[string]models.ShowFormat{
		"400x400": models.ShowFormat{
			PlaylistPreference: 1,
			Bitrate:            1,
			MaxIdrInterval:     1,
			Fps:                123.2,
		},
	}, converters.ConvertVinylShowFormats(map[string]map[string]interface{}{
		"400x400": map[string]interface{}{
			"playlist_preference": 1.2,
			"bitrate":             1.2,
			"max_idr_interval":    1.2,
			"fps":                 "123.2",
		},
	}))
}
