package converters

import (
	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/models"
)

// ConvertVinylThumbnailTemplates converts vinyl to internal model
func ConvertVinylThumbnailTemplates(thumbnailTemplates vinyl.ThumbnailTemplateList) []models.ThumbnailTemplate {
	result := make([]models.ThumbnailTemplate, len(thumbnailTemplates))
	for i := range thumbnailTemplates {
		result[i] = models.ThumbnailTemplate{
			Offset: thumbnailTemplates[i].Offset,
			Path:   thumbnailTemplates[i].Path,
			Type:   thumbnailTemplates[i].Type,
			URL:    thumbnailTemplates[i].URL,
		}
	}
	return result
}
