package converters

import (
	"testing"

	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
)

func TestThumbnailTemplates(t *testing.T) {
	Convey("when using thumbnail templates convertesr", t, func() {
		utils.StubTimeNow()

		Convey("when converting vinyl thumbnail templates", func() {
			input := vinyl.ThumbnailTemplateList{
				vinyl.ThumbnailTemplate{
					Offset: 1.2,
					Path:   "path",
					Type:   "type",
					URL:    "url",
				},
			}
			output := []models.ThumbnailTemplate{
				models.ThumbnailTemplate{
					Offset: input[0].Offset,
					Path:   input[0].Path,
					Type:   input[0].Type,
					URL:    input[0].URL,
				},
			}
			So(output, ShouldResemble, ConvertVinylThumbnailTemplates(input))
		})
	})
}
