package converters

import (
	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/models"
)

// ConvertInternalToVinylCreateThumbnails converts internal to vinyl model
func ConvertInternalToVinylCreateThumbnails(createThumbnails *models.CreateThumbnailsRequest) vinyl.CreateThumbnailsInput {
	thumbnails := make([]*vinyl.Thumbnail, len(createThumbnails.Thumbnails))
	for i, thumbnail := range createThumbnails.Thumbnails {
		thumbnails[i] = &vinyl.Thumbnail{
			Path: thumbnail.Path,
		}
		if thumbnail.Offset != nil {
			val := float32(*thumbnail.Offset)
			thumbnails[i].Offset = (*vinyl.DynamicFloat32)(&val)
		}
	}
	return vinyl.CreateThumbnailsInput{
		Thumbnails: thumbnails,
	}
}

// ConvertVinylCreateThumbnails converts vinyl to internal model
func ConvertVinylCreateThumbnails(createThumbnails *vinyl.CreateThumbnailsOutput) *models.CreateThumbnailsResponse {
	thumbnails := make([]models.Thumbnail, len(createThumbnails.Thumbnails))
	for i, thumbnail := range createThumbnails.Thumbnails {
		thumbnails[i] = models.Thumbnail{
			Path: thumbnail.Path,
		}
		if thumbnail.Offset != nil {
			val := float64(*thumbnail.Offset)
			thumbnails[i].Offset = &val
		}
	}
	return &models.CreateThumbnailsResponse{
		Thumbnails: thumbnails,
	}
}

// ConvertVinylCreateCustomThumbnailUpload converts vinyl to internal model
func ConvertVinylCreateCustomThumbnailUpload(createThumbnailUpload *vinyl.CustomThumbnailUploadRequest) *models.CreateCustomThumbnailUploadRequestResponse {
	return &models.CreateCustomThumbnailUploadRequestResponse{
		URL:      createThumbnailUpload.URL,
		UploadID: createThumbnailUpload.UploadID,
	}
}
