package converters

import (
	"testing"

	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/models"
	"code.justin.tv/vod/vodapi/rpc/vodapi/utils"
	. "github.com/smartystreets/goconvey/convey"
)

func TestThumbnails(t *testing.T) {
	Convey("when using thumbnails convertesr", t, func() {
		utils.StubTimeNow()

		Convey("when converting internal to vinyl create thumbnails", func() {
			input := &models.CreateThumbnailsRequest{
				VodID: 1234,
				Thumbnails: []models.ThumbnailRequest{
					models.ThumbnailRequest{
						Path: "path",
					},
				},
			}
			output := vinyl.CreateThumbnailsInput{
				Thumbnails: []*vinyl.Thumbnail{
					&vinyl.Thumbnail{
						Path: input.Thumbnails[0].Path,
					},
				},
			}
			So(output, ShouldResemble, ConvertInternalToVinylCreateThumbnails(input))
		})
		Convey("when converting vinyl create thumbnails", func() {
			input := &vinyl.CreateThumbnailsOutput{
				Thumbnails: []*vinyl.Thumbnail{
					&vinyl.Thumbnail{
						Path: "path",
					},
				},
			}
			output := &models.CreateThumbnailsResponse{
				Thumbnails: []models.Thumbnail{
					models.Thumbnail{
						Path: input.Thumbnails[0].Path,
					},
				},
			}
			So(output, ShouldResemble, ConvertVinylCreateThumbnails(input))
		})
		Convey("when converting from internal thumbnails response", func() {
			input := &vinyl.CustomThumbnailUploadRequest{
				URL:      "url",
				UploadID: "upload_id",
			}
			output := &models.CreateCustomThumbnailUploadRequestResponse{
				URL:      input.URL,
				UploadID: input.UploadID,
			}
			So(output, ShouldResemble, ConvertVinylCreateCustomThumbnailUpload(input))
		})
	})
}
