package converters

import (
	vinyl "code.justin.tv/vod/vinyl/client"
	"code.justin.tv/vod/vodapi/internal/models"
)

// ConvertVinylUserVodProperties converts vinyl to internal model
func ConvertVinylUserVodProperties(userVodProperties *vinyl.UserVODProperties) *models.UserVodPropertiesResponse {
	return &models.UserVodPropertiesResponse{
		ChannelID:                userVodProperties.UserID,
		SaveVodsForever:          userVodProperties.SaveVODsForever,
		VodStorageDays:           int64(userVodProperties.VODStorageDays),
		CanUploadVod:             userVodProperties.CanUploadVOD,
		YoutubeExportingDisabled: userVodProperties.YoutubeExportingDisabled,
		SkipMuting:               userVodProperties.SkipMuting,
		SkipUploadModeration:     userVodProperties.SkipUploadModeration,
		CanUploadUnlimited:       userVodProperties.CanUploadUnlimited,
		CreatedAt:                userVodProperties.CreatedAt,
		UpdatedAt:                userVodProperties.UpdatedAt,
	}
}

// ConvertVinylUserVideoPrivacyProperties converts vinyl to internal model
func ConvertVinylUserVideoPrivacyProperties(userVideoPrivacyProperties *vinyl.UserVideoPrivacyProperties) *models.UserVideoPrivacyPropertiesResponse {
	return &models.UserVideoPrivacyPropertiesResponse{
		ChannelID:           userVideoPrivacyProperties.UserID,
		HideArchives:        userVideoPrivacyProperties.HideArchives,
		HideArchivesEnabled: userVideoPrivacyProperties.HideArchivesEnabled,
		CreatedAt:           userVideoPrivacyProperties.CreatedAt,
		UpdatedAt:           userVideoPrivacyProperties.UpdatedAt,
	}
}
